/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator;

import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskListener;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.diskmanipulator.NetworkNodeDiskManipulator;
import com.raoulvdberge.refinedstorage.render.constants.ConstantsDisk;
import com.raoulvdberge.refinedstorage.util.WorldUtils;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class StorageDiskFluidManipulatorWrapper
implements IStorageDisk<FluidStack> {
    private final NetworkNodeDiskManipulator diskManipulator;
    private final IStorageDisk<FluidStack> parent;
    private int lastState;

    public StorageDiskFluidManipulatorWrapper(NetworkNodeDiskManipulator diskManipulator, IStorageDisk<FluidStack> parent) {
        this.diskManipulator = diskManipulator;
        this.parent = parent;
        this.setSettings(() -> {
            int currentState = ConstantsDisk.getDiskState(this.getStored(), this.getCapacity());
            if (this.lastState != currentState) {
                this.lastState = currentState;
                WorldUtils.updateBlock(diskManipulator.getNetworkNodeWorld(), diskManipulator.getNetworkNodePos());
            }
        }, diskManipulator);
        this.lastState = ConstantsDisk.getDiskState(this.getStored(), this.getCapacity());
    }

    @Override
    public long getCapacity() {
        return this.parent.getCapacity();
    }

    @Override
    public void setSettings(@Nullable IStorageDiskListener listener, IStorageDiskContainerContext context) {
        this.parent.setSettings(listener, context);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        return this.parent.writeToNbt();
    }

    @Override
    public String getId() {
        return this.parent.getId();
    }

    @Override
    public Collection<FluidStack> getStacks() {
        return this.parent.getStacks();
    }

    @Override
    public Collection<StackListEntry<FluidStack>> getEntries() {
        return this.parent.getEntries();
    }

    @Override
    @Nullable
    public StackListResult<FluidStack> insert(@Nonnull FluidStack stack, long size, Action action) {
        if (!this.diskManipulator.getConfig().acceptsFluid(stack)) {
            return new StackListResult<FluidStack>(stack.copy(), size);
        }
        return this.parent.insert(stack, size, action);
    }

    @Override
    @Nullable
    public StackListResult<FluidStack> extract(@Nonnull FluidStack stack, long size, int flags, Action action) {
        if (!this.diskManipulator.getConfig().acceptsFluid(stack)) {
            return null;
        }
        return this.parent.extract(stack, size, flags, action);
    }

    @Override
    public long getStored() {
        return this.parent.getStored();
    }

    @Override
    public int getPriority() {
        return this.parent.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.parent.getAccessType();
    }

    @Override
    public long getCacheDelta(long storedPreInsertion, long size, long remainder) {
        return this.parent.getCacheDelta(storedPreInsertion, size, remainder);
    }
}

